/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess.impl;

import java.util.ArrayList;
import java.util.List;

public abstract class TopoSorter<E> {
    public static final boolean REVERSE = true;
    private static final int UNMARKED = 0;
    private static final int TEMP_MARK = 1;
    private static final int PERM_MARK = 2;
    private final List<E> _values;
    private final List<Node<E>> _nodes = new ArrayList<Node<E>>();
    private final boolean _reverse;

    protected TopoSorter(List<E> values, boolean reverse) {
        this._values = values;
        this._reverse = reverse;
    }

    public void sort() {
        for (E e : this._values) {
            Node node = new Node(e);
            this.getDescendents(e, node._descs);
            this._nodes.add(0, node);
        }
        this._values.clear();
        for (Node node : this._nodes) {
            if (node._mark != 0) continue;
            this.visit(node);
        }
    }

    private void visit(Node<E> node) {
        if (((Node)node)._mark == 2) {
            return;
        }
        if (((Node)node)._mark == 1) {
            throw new IllegalStateException("Cycle detected");
        }
        ((Node)node)._mark = 1;
        for (Object descVal : ((Node)node)._descs) {
            Node desc = this.findDescendent(descVal);
            this.visit(desc);
        }
        ((Node)node)._mark = 2;
        if (this._reverse) {
            this._values.add(((Node)node)._val);
        } else {
            this._values.add(0, ((Node)node)._val);
        }
    }

    private Node<E> findDescendent(E val) {
        for (Node<E> node : this._nodes) {
            if (((Node)node)._val != val) continue;
            return node;
        }
        throw new IllegalStateException("Unknown descendent " + val);
    }

    protected abstract void getDescendents(E var1, List<E> var2);

    private static class Node<E> {
        private final E _val;
        private final List<E> _descs = new ArrayList();
        private int _mark = 0;

        private Node(E val) {
            this._val = val;
        }
    }
}

